
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points for each religious group with (Affiliation Rate, Community Engagement Score)
christianity = [(0.70, 85), (0.75, 90)]
islam = [(0.60, 88), (0.65, 85)]
hinduism = [(0.50, 80), (0.55, 78)]
buddhism = [(0.40, 75), (0.45, 74)]
judaism = [(0.30, 70), (0.35, 72)]
other = [(0.20, 65), (0.25, 68)]
labels = ["Christianity", "Islam", "Hinduism", "Buddhism", "Judaism", "Other"]
xlabel = "Affiliation Rate"
ylabel = "Community Engagement Score"
title = "Scatter Plot of Community Engagement Score vs Affiliation Rate"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a scatter plot
fig, ax = plt.subplots(figsize=(10, 6))

# Plot each group with different color and marker
ax.scatter(*zip(*christianity), color="#2E8B57", label=labels[0], s=100, marker="o")  # SeaGreen
ax.scatter(*zip(*islam), color="#4682B4", label=labels[1], s=100, marker="^")  # SteelBlue
ax.scatter(*zip(*hinduism), color="#6A5ACD", label=labels[2], s=100, marker="s")  # SlateBlue
ax.scatter(*zip(*buddhism), color="#FF8C00", label=labels[3], s=100, marker="D")  # DarkOrange
ax.scatter(*zip(*judaism), color="#8A2BE2", label=labels[4], s=100, marker="P")  # BlueViolet
ax.scatter(*zip(*other), color="#20B2AA", label=labels[5], s=100, marker="*")  # LightSeaGreen

# Add legend
ax.legend(loc="upper left")

# Add labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
fig.tight_layout()
plt.savefig("scatter_38.pdf", bbox_inches="tight")
