# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data points for each education level group (Years of Education, Average Monthly Income)
high_school = [(12, 2500), (11, 2300), (13, 2600)]
bachelor = [(16, 4000), (15, 3800), (17, 4200)]
masters = [(18, 5000), (19, 5200), (20, 5300)]
phd = [(22, 7000), (23, 7500), (21, 6900)]
labels = ["High School", "Bachelor's", "Master's", "PhD"]
xlabel = "Years of Education"
ylabel = "Average Monthly Income ($)"
title = "Scatter Plot of Income vs Education Level"
annotation_text = "Key PhD Data Point"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a scatter plot
fig, ax = plt.subplots(figsize=(8, 8))

# Custom color scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot each group with different color and marker
ax.scatter(
    *zip(*high_school), color=colors[0], label=labels[0], marker="o", s=100, alpha=0.7
)
ax.scatter(
    *zip(*bachelor), color=colors[1], label=labels[1], marker="s", s=100, alpha=0.7
)
ax.scatter(
    *zip(*masters), color=colors[2], label=labels[2], marker="^", s=100, alpha=0.7
)
ax.scatter(*zip(*phd), color=colors[3], label=labels[3], marker="D", s=100, alpha=0.7)

# Add legend
ax.legend(loc="upper left")

# Add labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)

# Add grid for better readability
ax.grid(True, which="both", linestyle="--", linewidth=0.5)

# Highlight a particular data point with annotation (example)
highlight_point = (22, 7000)
ax.annotate(
    annotation_text,
    xy=highlight_point,
    xytext=(24, 7300),
    arrowprops=dict(facecolor="black", arrowstyle="->"),
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
fig.tight_layout()
plt.savefig("scatter_39.pdf", bbox_inches="tight")
