
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulate some data for the scatter plot
n_points = 200
christianity_x = np.random.normal(0.6, 0.1, n_points)
christianity_y = np.random.normal(0.3, 0.1, n_points)
islam_x = np.random.normal(-0.2, 0.1, n_points)
islam_y = np.random.normal(0.4, 0.1, n_points)
hinduism_x = np.random.normal(0.1, 0.1, n_points)
hinduism_y = np.random.normal(-0.3, 0.1, n_points)
buddhism_x = np.random.normal(-0.4, 0.1, n_points)
buddhism_y = np.random.normal(-0.2, 0.1, n_points)

xlabel = "Principle Importance"
ylabel = "Belief Proportion"
title = "Religion Belief Distribution"
legend_title = "Religion"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
plt.figure(figsize=(10, 10))
plt.scatter(christianity_x, christianity_y, color="#1f77b4", alpha=0.6, marker='o', label="Christianity")
plt.scatter(islam_x, islam_y, color="#ff7f0e", alpha=0.6, marker='s', label="Islam")
plt.scatter(hinduism_x, hinduism_y, color="#2ca02c", alpha=0.6, marker='^', label="Hinduism")
plt.scatter(buddhism_x, buddhism_y, color="#d62728", alpha=0.6, marker='d', label="Buddhism")

# Add grid lines for better readability
plt.grid(True, linestyle='--', alpha=0.7)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend(title=legend_title, ncol=2, bbox_to_anchor=(0.5, -0.1), loc="upper center", frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_47.pdf", bbox_inches="tight")
