# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulate height (cm) and weight (kg) for different age groups
n_points = 200
children_height = np.random.normal(125, 10, n_points)
children_weight = np.random.normal(30, 5, n_points)
teen_height = np.random.normal(160, 10, n_points)
teen_weight = np.random.normal(50, 7, n_points)
adult_height = np.random.normal(170, 10, n_points)
adult_weight = np.random.normal(70, 10, n_points)
senior_height = np.random.normal(165, 10, n_points)
senior_weight = np.random.normal(65, 8, n_points)

xlabel = "Height (cm)"
ylabel = "Weight (kg)"
title = "Height vs Weight Distribution across Age Groups"
legendtitle = "Age Groups"
scatter_labels = ["Teenagers", "Adults", "Seniors"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
plt.figure(figsize=(10, 10))
plt.scatter(
    children_height,
    children_weight,
    color="#1f77b4",
    alpha=0.6,
    label="Children",
    marker="o",
)
plt.scatter(
    teen_height,
    teen_weight,
    color="#ff7f0e",
    alpha=0.6,
    label=scatter_labels[0],
    marker="s",
)
plt.scatter(
    adult_height,
    adult_weight,
    color="#2ca02c",
    alpha=0.6,
    label=scatter_labels[1],
    marker="^",
)
plt.scatter(
    senior_height,
    senior_weight,
    color="#9467bd",
    alpha=0.6,
    label=scatter_labels[2],
    marker="d",
)

plt.tick_params(axis="both", length=0)

# Add labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14, pad=20)
plt.legend(
    title=legendtitle,
    ncol=2,
    bbox_to_anchor=(0.5, 1.15),
    loc="upper center",
    frameon=False,
)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_48.pdf", bbox_inches="tight")
