# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulate some data for the scatter plot representing different art styles
n_points = 200
abstract_x = np.random.normal(0.6, 0.05, n_points)
abstract_y = np.random.normal(0.5, 0.05, n_points)
modern_x = np.random.normal(-0.1, 0.05, n_points)
modern_y = np.random.normal(0.2, 0.05, n_points)
classic_x = np.random.normal(-0.3, 0.05, n_points)
classic_y = np.random.normal(-0.4, 0.05, n_points)
impressionism_x = np.random.normal(0.2, 0.05, n_points)
impressionism_y = np.random.normal(-0.1, 0.05, n_points)

xlabel = "Art Style Dimension 1"
ylabel = "Art Style Dimension 2"
title = "Distribution of Art Styles"

legend_title = "Art Movements"

labels = ["Abstract", "Modern", "Classic", "Impressionism"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
plt.figure(figsize=(10, 10))
plt.scatter(
    abstract_x, abstract_y, color="#FF5733", alpha=0.6, marker="o", label=labels[0]
)
plt.scatter(modern_x, modern_y, color="#33FF57", alpha=0.6, marker="^", label=labels[1])
plt.scatter(
    classic_x, classic_y, color="#3357FF", alpha=0.6, marker="s", label=labels[2]
)
plt.scatter(
    impressionism_x,
    impressionism_y,
    color="#FF33A1",
    alpha=0.6,
    marker="x",
    label=labels[3],
)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title, fontsize=16)
plt.legend(
    title=legend_title,
    ncol=2,
    bbox_to_anchor=(0.5, 1.05),
    loc="lower center",
    frameon=False,
    fontsize=10,
)
plt.grid(True, linestyle="--", alpha=0.5)
plt.tick_params(
    axis="both", length=6, width=2, colors="gray", grid_color="gray", grid_alpha=0.5
)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_49.pdf", bbox_inches="tight")
