# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from matplotlib.lines import Line2D
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for Air Quality plot (AQI)
aqi_x = [45, 50, 30, 70, 65]
aqi_y = [5, 7, 4, 8, 6]
aqi_labels = ["Downtown", "Suburb", "Industrial", "Park", "Residential"]

# Data for Traffic Congestion plot (TCI)
tci_x = [10, 20, 15, 25, 30]
tci_y = [3, 5, 4, 6, 7]
tci_labels = ["Morning", "Noon", "Evening", "Night", "Rush Hour"]

# Extracted variables for plot configuration
aqi_title = "Air Quality Index"
aqi_xlabel = "AQI"
aqi_ylabel = "Number of Complaints"
aqi_xlim = (20, 80)
aqi_xticks = [20, 30, 40, 50, 60, 70, 80]
aqi_ylim = (3, 9)
aqi_yticks = [3, 4, 5, 6, 7, 8, 9]

tci_title = "Traffic Congestion Index"
tci_xlabel = "Congestion Level"
tci_ylabel = "Accidents Reported"
tci_xlim = (5, 35)
tci_xticks = [5, 10, 15, 20, 25, 30, 35]
tci_ylim = (2, 8)
tci_yticks = [2, 3, 4, 5, 6, 7, 8]

# Colors for categories
aqi_colors = ["#76b7b2", "#4e79a7", "#f28e2c", "#e15759", "#59a14f"]
tci_colors = ["#76b7b2", "#4e79a7", "#f28e2c", "#e15759", "#59a14f"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(7, 10))

# AQI plot
for x, y, color, label in zip(aqi_x, aqi_y, aqi_colors, aqi_labels):
    ax1.scatter(x, y, label=label, color=color, s=200)  # Increase marker size
ax1.set_title(aqi_title)
ax1.set_xlabel(aqi_xlabel)
ax1.set_ylabel(aqi_ylabel)
ax1.set_xlim(aqi_xlim)  # Adjust x-axis range
ax1.set_xticks(aqi_xticks)
ax1.set_ylim(aqi_ylim)  # Adjust y-axis range
ax1.set_yticks(aqi_yticks)
ax1.grid(True, linestyle="--", linewidth=0.5, color="black")  # Add grid

# TCI plot
for x, y, color, label in zip(tci_x, tci_y, tci_colors, tci_labels):
    ax2.scatter(x, y, label=label, color=color, s=200)  # Increase marker size
ax2.set_title(tci_title)
ax2.set_xlabel(tci_xlabel)
ax2.set_ylabel(tci_ylabel)
ax2.set_xlim(tci_xlim)  # Adjust x-axis range
ax2.set_xticks(tci_xticks)
ax2.set_ylim(tci_ylim)  # Adjust y-axis range
ax2.set_yticks(tci_yticks)
ax2.grid(True, linestyle="--", linewidth=0.5, color="black")  # Add grid

legend_elements = [
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Downtown",
        markersize=10,
        markerfacecolor="#76b7b2",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Suburb",
        markersize=10,
        markerfacecolor="#4e79a7",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Industrial",
        markersize=10,
        markerfacecolor="#f28e2c",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Park",
        markersize=10,
        markerfacecolor="#e15759",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Residential",
        markersize=10,
        markerfacecolor="#59a14f",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Morning",
        markersize=10,
        markerfacecolor="#76b7b2",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Noon",
        markersize=10,
        markerfacecolor="#4e79a7",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Evening",
        markersize=10,
        markerfacecolor="#f28e2c",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Night",
        markersize=10,
        markerfacecolor="#e15759",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Rush Hour",
        markersize=10,
        markerfacecolor="#59a14f",
    ),
]

# Create the legend using the custom handles
fig.legend(
    handles=legend_elements,
    loc="lower center",
    ncol=5,
    borderaxespad=0.05,
    frameon=False,
    bbox_to_anchor=(0.5, -0.05),
)

# Adjust the layout to make room for the legend
plt.subplots_adjust(bottom=0.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_50.pdf", bbox_inches="tight")
