# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
# Data for Innovation plot
innovation_x = [0.88, 0.82, 0.92, 0.72, 0.96]
innovation_y = [25, 30, 35, 20, 40]
innovation_labels = ["TechCorp", "InnovateX", "NextGen", "FutureTech", "Visionary"]

# Data for Market Share plot
market_share_x = [0.88, 0.62, 0.86, 0.89, 0.92]
market_share_y = [15, 12, 18, 10, 20]
market_share_labels = ["TechCorp", "InnovateX", "NextGen", "FutureTech", "Visionary"]

# Extracted variables for plot configuration
innovation_title = "Innovation Index vs Market Share"
innovation_xlabel = "Innovation Index"
innovation_ylabel = "Percentage"
innovation_xlim = (0.6, 1.1)
innovation_xticks = [0.6, 0.7, 0.8, 0.9, 1.0, 1.1]
innovation_ylim = (15, 45)
innovation_yticks = [15, 20, 25, 30, 35, 40, 45]

market_share_title = "Market Share Percentage vs Innovation Index"
market_share_xlabel = "Innovation Index"
market_share_ylabel = "Market Share Percentage"
market_share_xlim = (0.5, 1.0)
market_share_xticks = [0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
market_share_ylim = (10, 25)
market_share_yticks = [10, 15, 20, 25]

labels = []

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(7, 10))

innovation_colors = ["#003f5c", "#2f4b7c", "#665191", "#a05195", "#d45087"]
market_share_colors = ["#003f5c", "#2f4b7c", "#665191", "#a05195", "#d45087"]
innovation_markers = ["o", "s", "D", "^", "P"]
market_share_markers = ["o", "s", "D", "^", "P"]

# Innovation plot
for x, y, color, label, marker in zip(
    innovation_x, innovation_y, innovation_colors, innovation_labels, innovation_markers
):
    if label == "TechCorp":
        ax1.scatter(
            x,
            y,
            label=label,
            facecolors="none",
            edgecolors=color,
            s=200,
            linewidths=4,
            marker=marker,
        )
    else:
        ax1.scatter(
            x, y, label=label, color=color, s=200, marker=marker
        )  # Increase marker size
ax1.set_title(innovation_title)
ax1.set_xlabel(innovation_xlabel)
ax1.set_ylabel(innovation_ylabel)
ax1.set_xlim(innovation_xlim)  # Adjust x-axis range
ax1.set_xticks(innovation_xticks)
ax1.set_ylim(innovation_ylim)  # Adjust y-axis range
ax1.set_yticks(innovation_yticks)
ax1.grid(True, linestyle="--", linewidth=0.5, color="gray")  # Add grid

# Market Share plot
for x, y, color, label, marker in zip(
    market_share_x,
    market_share_y,
    market_share_colors,
    market_share_labels,
    market_share_markers,
):
    if label == "TechCorp":
        ax2.scatter(
            x,
            y,
            label=label,
            facecolors="none",
            edgecolors=color,
            s=200,
            linewidths=4,
            marker=marker,
        )
    else:
        ax2.scatter(
            x, y, label=label, color=color, s=200, marker=marker
        )  # Increase marker size
ax2.set_title(market_share_title)
ax2.set_xlabel(market_share_xlabel)
ax2.set_ylabel(market_share_ylabel)
ax2.set_xlim(market_share_xlim)  # Adjust x-axis range
ax2.set_xticks(market_share_xticks)
ax2.set_ylim(market_share_ylim)  # Adjust y-axis range
ax2.set_yticks(market_share_yticks)
ax2.grid(True, linestyle="--", linewidth=0.5, color="gray")  # Add grid

legend_elements = [
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="TechCorp",
        markersize=10,
        markerfacecolor="none",
        markeredgewidth=4,
        markeredgecolor="#003f5c",
    ),
    Line2D(
        [0],
        [0],
        marker="s",
        color="w",
        label="InnovateX",
        markersize=10,
        markerfacecolor="#2f4b7c",
    ),
    Line2D(
        [0],
        [0],
        marker="D",
        color="w",
        label="NextGen",
        markersize=10,
        markerfacecolor="#665191",
    ),
    Line2D(
        [0],
        [0],
        marker="^",
        color="w",
        label="FutureTech",
        markersize=10,
        markerfacecolor="#a05195",
    ),
    Line2D(
        [0],
        [0],
        marker="P",
        color="w",
        label="Visionary",
        markersize=10,
        markerfacecolor="#d45087",
    ),
]

# Create the legend using the custom handles
fig.legend(
    handles=legend_elements,
    loc="lower center",
    ncol=5,
    borderaxespad=0.05,
    frameon=False,
)

# Adjust the layout to make room for the legend
plt.subplots_adjust(bottom=0.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_51.pdf", bbox_inches="tight")
