# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points (Year-wise Revenue in Billions, Number of Employees in Thousands)
years = [2016, 2017, 2018, 2019, 2020, 2021]
revenue = [2.5, 3.0, 3.8, 4.3, 5.1, 6.0]
employees = [15, 18, 21, 25, 30, 35]
labels = [None, "Year 2017", None, "Year 2019", "Year 2020", "Year 2021"]
dashed_lines = [(2016, 2.5, 2017, 3.0), (2019, 4.3, 2021, 6.0)]

title = "Tech Company Growth Over the Years"
xlabel = "Year"
ylabel = "Revenue (Billions)"
texts = ["+0.5B from 2016", "Growth Period", "+1.7B", "+1.7B from 2019"]

legend_labels = ["Revenue Growth", "Employees Growth"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data points
plt.figure(figsize=(10, 6))
plt.scatter(
    years, revenue, color="#2A9D8F", s=120, marker="o"
)  # Customized marker color and size

# Annotating the data points
for i, label in enumerate(labels):
    plt.annotate(
        label,
        (years[i], revenue[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Plotting the dashed lines with correct colors and annotations
plt.plot([2016, 2017], [2.5, 3.0], linestyle="--", color="#E76F51")
plt.annotate(texts[0], (2016.5, 2.75), color="#E76F51")
plt.plot([2016, 2018], [2.5, 3.8], linestyle="--", color="#264653")
plt.annotate(texts[1], (2017.5, 3.2), color="#264653")
plt.plot([2019, 2021], [4.3, 6.0], linestyle="--", color="#F4A261")
plt.annotate(
    texts[2],
    (2020.5, 5.15),
    color="#F4A261",
    textcoords="offset points",
    xytext=(0, 10),
    ha="center",
)

# Annotating the dashed lines correctly
plt.annotate(texts[3], (2020, 5.85), color="#F4A261")

# Setting the title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adjusting y-axis scale
plt.ylim(2, 7)
plt.yticks(np.arange(2, 7.5, 0.5))
plt.xlim(2015, 2022)
plt.xticks(np.arange(2016, 2022, 1))
plt.grid(True, linestyle="--", alpha=0.7)

# removing the top, left, and right spines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["left"].set_visible(False)

# Adding legend
plt.legend(legend_labels, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_54.pdf", bbox_inches="tight")
