# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
names = ["Device A", "Device B", "Device C", "Device D", "Device E", "Device F"]
x = [5, 10, 15, 20, 25, 30]  # Battery Life (hours)
y = [90, 85, 80, 75, 70, 65]  # Accuracy Rate (%)
sizes = [500, 1000, 1500, 2000, 2500, 3000]  # Number of Devices Sold

# Plot and legend labels
scatter_label = "Bubble Size: Number of Devices Sold"

# Axis limits
xlim_values = (1, 35)
ylim_values = (60, 95)

# Axis labels
xlabel_value = "Battery Life (hours)"
ylabel_value = "Accuracy Rate (%)"

# Axis ticks
xticks_values = [5, 10, 15, 20, 25, 30]
yticks_values = None  # Using default y-ticks

# Axis ticks labels
xtickslabel_values = None  # Using default labels
ytickslabel_values = None  # Using default labels

# Title
title_value = "Health Monitoring Devices Performance"

# Horizontal and vertical lines
axhline_values = None
axvline_values = None

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a scatter plot
fig, ax = plt.subplots(figsize=(8, 6))
colors = ["#2E8B57", "#3CB371", "#66CDAA", "#8FBC8F", "#20B2AA", "#5F9EA0"]
scatter = ax.scatter(
    x, y, s=sizes, c=colors, alpha=0.6, edgecolors="black", label=scatter_label
)

# Add labels for each bubble
for i, txt in enumerate(names):
    ax.annotate(txt, (x[i], y[i]), ha="center", va="center", fontsize=8, color="black")

# Set the x-axis to a logarithmic scale
ax.set_xscale("log")
ax.xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{int(x):d}"))
ax.xaxis.set_major_locator(ticker.FixedLocator(xticks_values))

# Set axis labels
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_xlim(xlim_values)
ax.set_ylim(ylim_values)

# Set plot title
ax.set_title(title_value, fontsize=14, fontweight="bold")

# Add grid
ax.grid(True, which="both", linestyle="--", linewidth=0.5)

# Set background color to white
fig.patch.set_facecolor("white")
ax.set_facecolor("white")

# Add legend
legend = ax.legend()

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [60]

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_56.pdf", bbox_inches="tight")
