# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
names = [
    "Aristotle",
    "Plato",
    "Descartes",
    "Kant",
    "Nietzsche",
    "Sartre",
    "Hume",
    "Heidegger",
    "Wittgenstein",
]
x = [70, 80, 60, 75, 85, 65, 50, 55, 95]
y = [80, 85, 75, 90, 88, 78, 65, 60, 95]
sizes = [300, 500, 700, 1000, 1200, 900, 400, 600, 1100]
xlabel = "Popularity"
ylabel = "Influence"
legend_sizes = [300, 500, 1000, 1200, 1500]
legend_labels = ["300P", "500P", "1KP", "1.2KP", ">1.5KP"]
legend_title = "Number of Publications"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and plot
fig, ax = plt.subplots(figsize=(10, 7))
colors = [
    "#377eb8",
    "#377eb8",
    "#4daf4a",
    "#4daf4a",
    "#f781bf",
    "#f781bf",
    "#a65628",
    "#a65628",
    "#984ea3",
]
scatter = ax.scatter(x, y, s=sizes, c=colors, alpha=0.6, edgecolors="w", linewidth=0.5)

# Add annotations
for i, name in enumerate(names):
    ax.annotate(
        name,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=9,
    )

# Customize the axes
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xlim(45, 100)
ax.set_ylim(55, 100)

# Add legend for bubble sizes
for size, label in zip(legend_sizes, legend_labels):
    ax.scatter([], [], c="grey", alpha=0.5, s=size, label=label)

# Adjust the legend to have increased spacing
legend = ax.legend(
    scatterpoints=1,
    frameon=False,
    labelspacing=2,
    handletextpad=1,
    columnspacing=5,
    title=legend_title,
    fontsize=10,
    loc="upper center",
    bbox_to_anchor=(0.5, 1.2),
    ncol=len(legend_sizes),
)

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]

plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_60.pdf", bbox_inches="tight")
