
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
test_case_index = np.arange(1, 6)
doctrine_a_satisfaction = [4.5, 4.7, 4.6, 4.8, 4.5]
doctrine_b_satisfaction = [4.3, 4.2, 4.4, 4.4, 4.5]
doctrine_c_satisfaction = [4.0, 4.1, 4.0, 4.2, 4.1]

# Labels and Titles
xlabel = "Survey Round"
ylabel = "Average Satisfaction Rating"
title = "Satisfaction Ratings Across Different Doctrines"

# Legend labels
doctrine_a_label = "Doctrine A"
doctrine_b_label = "Doctrine B"
doctrine_c_label = "Doctrine C"

# Plot limits
xlim_values = (0.5, 5.5)
ylim_values = (3.8, 5.0)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size
plt.figure(figsize=(10, 7))

# Plotting the data with customized marker sizes and colors
plt.scatter(
    test_case_index,
    doctrine_a_satisfaction,
    label=doctrine_a_label,
    color="#5DADE2",  # Soft blue
    clip_on=False,
    zorder=10,
    marker="o",
    s=200,
    edgecolor='k'
)
plt.scatter(
    test_case_index,
    doctrine_b_satisfaction,
    label=doctrine_b_label,
    clip_on=False,
    zorder=10,
    color="#58D68D",  # Soft green
    marker="s",
    s=200,
    edgecolor='k'
)
plt.scatter(
    test_case_index,
    doctrine_c_satisfaction,
    label=doctrine_c_label,
    clip_on=False,
    zorder=10,
    color="#AF7AC5",  # Soft purple
    marker="^",
    s=200,
    edgecolor='k'
)

# Adding labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title, y=1.03)

# Adding a legend
handles, labels = plt.gca().get_legend_handles_labels()
order = [0, 1, 2] 
plt.legend(
    [handles[idx] for idx in order], 
    [labels[idx] for idx in order],
    loc="best",
    ncol=3,
    frameon=True,
    framealpha=0.5
)

plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Show grid
plt.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_63.pdf", bbox_inches="tight")
