
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================

# Data for plotting
years = [2018, 2019, 2020, 2021, 2022]
city_A_population = [1000, 1100, 1200, 1300, 1400]  # in thousands
city_B_population = [950, 970, 990, 1010, 1030]  # in thousands
city_C_population = [800, 850, 900, 950, 1000]  # in thousands

# Labels and Titles
xlabel = "Year"
ylabel = "Population (in thousands)"
title = "Population Growth Over Years"

# Legend labels
city_A_label = "City A"
city_B_label = "City B"
city_C_label = "City C"

# Plot limits
xlim_values = (2017.5, 2022.5)
ylim_values = (750, 1450)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Set figure size in inches to match the original image's dimensions
plt.figure(figsize=(10, 8))

# Plotting the data with adjusted marker sizes
plt.scatter(
    years,
    city_A_population,
    label=city_A_label,
    color="#1f77b4",  # Light blue
    marker="o",
    s=100,
    zorder=10
)
plt.scatter(
    years,
    city_B_population,
    label=city_B_label,
    color="#ff7f0e",  # Orange
    marker="s",
    s=100,
    zorder=10
)
plt.scatter(
    years,
    city_C_population,
    label=city_C_label,
    color="#2ca02c",  # Green
    marker="^",
    s=100,
    zorder=10
)

# Adding labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title, y=1.05)

# Adding a legend with adjusted order
handles, labels = plt.gca().get_legend_handles_labels()
order = [0, 1, 2]  # Order to match the reference picture
plt.legend(
    [handles[idx] for idx in order],
    [labels[idx] for idx in order],
    loc="upper left",
    frameon=False,
    ncol=3
)

plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Show grid
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================

# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_64.pdf", bbox_inches="tight")

