
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "Impressionism",
    "Cubism",
    "Surrealism",
    "Expressionism",
    "Baroque",
    "Renaissance",
    "Modernism",
    "Realism",
]
majority_preference = [0.85, 0.80, 0.75, 0.70, 0.65, 0.60, 0.55, 0.50]
minority_preference = [0.15, 0.20, 0.25, 0.30, 0.35, 0.40, 0.45, 0.50]
xlabel = "Art Movements"
ylabel = "Preference Rating"
labels = ["Majority Preference", "Minority Preference"]
title = "Art Movement Preferences across Different Styles (Art Survey)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size
plt.figure(figsize=(8, 4))

# Plotting the data
plt.scatter(categories, majority_preference, color="#FF5733", label=labels[0], marker='o')
plt.scatter(categories, minority_preference, color="#33C1FF", label=labels[1], marker='s')

# Adding labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)

# Adding grid
plt.grid(True, linestyle="--", linewidth=0.5)

# Rotate x-axis labels for better readability
plt.xticks(rotation=45, fontsize=10)
plt.ylim(0, 1)

# Adjusting legend placement
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("scatter_65.pdf", bbox_inches="tight")
