# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate new data for population domain
np.random.seed(0)
# Simulating Population Growth Rate and Urbanization Rate data
population_growth_rate = np.random.normal(2, 0.5, 100)  # Mean growth rate 2%, std 0.5%
urbanization_rate = np.random.normal(60, 5, 100)  # Mean urbanization rate 60%, std 5%
xlabel = "Population Growth Rate (%)"
ylabel = "Urbanization Rate (%)"
title = "Scatter Plot of Population Growth vs Urbanization Rate"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
plt.figure(figsize=(9, 6))

# Scatter plot for the population data
colors = np.random.rand(100)  # Random colors
sizes = 1000 * np.random.rand(100)  # Random sizes for the markers
plt.scatter(
    population_growth_rate,
    urbanization_rate,
    c=colors,
    s=sizes,
    alpha=0.6,
    cmap="plasma",
    edgecolor="w",
)

# Enhance visibility of the grid
plt.grid(True, linestyle="--", linewidth=0.7, alpha=0.6)

# Set labels and title for the plot
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_75.pdf", bbox_inches="tight")
