# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# City A: Population and Average Age
population_city_a = np.array(
    [150, 200, 220, 240, 180, 300, 190, 260, 210, 280, 330, 270, 230]
)
age_city_a = np.array([35, 42, 39, 40, 45, 50, 37, 41, 43, 38, 36, 48, 42])

# City B: Population and Average Age
population_city_b = np.array(
    [180, 220, 250, 210, 270, 300, 230, 260, 280, 240, 320, 310, 290]
)
age_city_b = np.array([30, 38, 35, 32, 39, 42, 31, 36, 37, 34, 33, 40, 35])

xlabel = "Population (in thousands)"
ylabel = "Average Age"
title = "Population vs. Average Age in Two Cities"
legend_labels = ["City A", "City B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
plt.scatter(
    population_city_a, age_city_a, color="skyblue", marker="o", edgecolor="black", s=100
)
plt.scatter(
    population_city_b, age_city_b, color="salmon", marker="^", edgecolor="black", s=100
)
plt.grid(True, linestyle="--", alpha=0.7)

plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend(legend_labels, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_79.pdf", bbox_inches="tight")
