# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the scatter plot representing annual income and expenditure
x = np.array([50, 70, 80, 90, 20, 170, 30, 60, 40, 110, 120, 95, 65])
y = np.array([40, 65, 60, 75, 25, 150, 35, 55, 45, 95, 105, 80, 70])
xlabel = "Annual Income (in $1000)"
ylabel = "Annual Expenditure (in $1000)"
title = "Income vs Expenditure"
annotate_text = "High Income, High Expenditure"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))  # Adjust the figure size for better detail
colors = np.linspace(
    0, 1, len(x)
)  # Create a color gradient based on the number of points
plt.scatter(x, y, c=colors, cmap="plasma", s=100, edgecolor="k", alpha=0.7, marker="o")
plt.grid(True, linestyle="--", linewidth=0.7)
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=15)
plt.colorbar(label="Color Intensity")
plt.annotate(
    annotate_text,
    xy=(170, 150),
    xytext=(100, 120),
    arrowprops=dict(facecolor="black", shrink=0.05),
    fontsize=10,
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_80.pdf", bbox_inches="tight")
