
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the scatter plot
days = np.arange(1, 15)  # Days from 1 to 14
temperature = np.random.uniform(15, 30, size=14)  # Temperatures between 15 and 30 degrees Celsius
humidity = np.random.uniform(40, 80, size=14)  # Humidity levels between 40% and 80%

# Labels and text
xlabel = "Temperature (°C)"
ylabel = "Humidity (%)"
title = "Temperature vs. Humidity over Two Weeks"
cbar_label = "Days"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
colors = days  # Color by day
scatter = plt.scatter(temperature, humidity, c=colors, cmap="coolwarm", edgecolor='k', s=100)
plt.grid(True, linestyle='--', alpha=0.7)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
cbar = plt.colorbar(scatter)
cbar.set_label(cbar_label)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_81.pdf", bbox_inches="tight")
