# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulating economic data
x = np.random.randint(1000, 10000, size=(20))  # GDP values in billion dollars
y = np.random.uniform(3, 15, size=(20))  # Unemployment rate in percentage
sizes = np.random.uniform(10, 100, size=(20)) * 10  # Population in millions

# Text label parameters
title = "Economic Indicators: GDP vs Unemployment Rate"
xlabel = "GDP (Billion $)"
ylabel = "Unemployment Rate (%)"
legend_title = "Population Size"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 7))
colors = np.random.rand(20)  # Color by some economic indicators

sc = plt.scatter(
    x, y, c=colors, s=sizes, alpha=0.6, cmap="coolwarm", edgecolor="k", linewidth=0.5
)
plt.colorbar(sc, label="Economic Indicator (normalized)")
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)


# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_85.pdf", bbox_inches="tight")
