# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
income_brackets = np.array(
    [1, 2, 3, 4, 5, 6, 7]
)  # Representing different income brackets
speech_system1 = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(income_brackets)))
    + np.random.normal(0, 0.1, len(income_brackets)),
    0.2,
    0.9,
)
speech_system2 = np.clip(
    np.cos(np.linspace(0, 2 * np.pi, len(income_brackets)))
    + np.random.normal(0, 0.1, len(income_brackets)),
    0.3,
    1,
)
additional_data1 = np.clip(
    np.sin(np.linspace(0, 1 * np.pi, len(income_brackets)))
    + np.random.normal(0, 0.1, len(income_brackets)),
    0.3,
    0.8,
)
additional_data2 = np.clip(
    np.cos(np.linspace(0, 1.5 * np.pi, len(income_brackets)))
    + np.random.normal(0, 0.05, len(income_brackets)),
    0.4,
    0.9,
)
titles = ["System 1 vs Additional Data 1", "System 2 vs Additional Data 2"]
figure1_scatter_labels = ["System 1 WER", "Additional Data 1"]
figure2_scatter_labels = ["System 2 WER", "Additional Data 2"]
xlabel = "Income Brackets"
ylabel = "WER(%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# The first subplot plots System 1 data and Additional Data 1
ax1.scatter(
    income_brackets,
    speech_system1,
    color="#1f77b4",  # blue
    label=figure1_scatter_labels[0],
    marker="o",
    s=80,
    edgecolor="black",
)
ax1.scatter(
    income_brackets,
    additional_data1,
    color="#ff7f0e",  # orange
    label=figure1_scatter_labels[1],
    marker="s",
    s=80,
    edgecolor="black",
)
ax1.set_title(titles[0], fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.legend(loc="upper right")

# The second subplot plots System 2 data and Additional Data 2
ax2.scatter(
    income_brackets,
    speech_system2,
    color="#2ca02c",  # green
    label=figure2_scatter_labels[0],
    marker="^",
    s=80,
    edgecolor="black",
)
ax2.scatter(
    income_brackets,
    additional_data2,
    color="#d62728",  # red
    label=figure2_scatter_labels[1],
    marker="d",
    s=80,
    edgecolor="black",
)
ax2.set_title(titles[1], fontsize=14)
ax2.set_xlabel(xlabel, fontsize=12)
ax2.set_ylabel(ylabel, fontsize=12)
ax2.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("scatter_86.pdf", bbox_inches="tight")
