
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(0)
years = np.array([2000, 2005, 2010, 2015, 2020, 2025, 2030])
existentialism_popularity = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(years))) + np.random.normal(0, 0.1, len(years)), 
    0.2, 
    0.9
)
stoicism_popularity = np.clip(
    np.cos(np.linspace(0, 2 * np.pi, len(years))) + np.random.normal(0, 0.1, len(years)), 
    0.3, 
    1
)
nihilism_popularity = np.clip(
    np.sin(np.linspace(0, 1 * np.pi, len(years))) + np.random.normal(0, 0.1, len(years)), 
    0.3, 
    0.8
)
absurdism_popularity = np.clip(
    np.cos(np.linspace(0, 1.5 * np.pi, len(years))) + np.random.normal(0, 0.05, len(years)), 
    0.4, 
    0.9
)
titles = ["Existentialism vs. Nihilism Popularity", "Stoicism vs. Absurdism Popularity"]
figure1_scatter_labels = ["Existentialism Popularity", "Nihilism Popularity"]
figure2_scatter_labels = ["Stoicism Popularity", "Absurdism Popularity"]
xlabel = "Year"
ylabel = "Popularity Index"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# The first subplot plots Existentialism and Nihilism data
ax1.scatter(
    years, 
    existentialism_popularity, 
    color="#92c5de", 
    label=figure1_scatter_labels[0], 
    marker="o", 
    s=80, 
    edgecolor="black"
)
ax1.scatter(
    years, 
    nihilism_popularity, 
    color="#0571b0", 
    label=figure1_scatter_labels[1], 
    marker="s", 
    s=80, 
    edgecolor="black"
)
ax1.set_title(titles[0], fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.legend(loc="upper right")

# The second subplot plots Stoicism and Absurdism data
ax2.scatter(
    years, 
    stoicism_popularity, 
    color="#f4a582", 
    label=figure2_scatter_labels[0], 
    marker="^", 
    s=80, 
    edgecolor="black"
)
ax2.scatter(
    years, 
    absurdism_popularity, 
    color="#ca0020", 
    label=figure2_scatter_labels[1], 
    marker="d", 
    s=80, 
    edgecolor="black"
)
ax2.set_title(titles[1], fontsize=14)
ax2.set_xlabel(xlabel, fontsize=12)
ax2.set_ylabel(ylabel, fontsize=12)
ax2.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("scatter_88.pdf", bbox_inches="tight")
