# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
languages = [
    "Python",
    "JavaScript",
    "Java",
    "C++",
    "C#",
    "Ruby",
    "Go",
    "Swift",
    "Kotlin",
]
values = {
    "Popularity": [9.5, 8.8, 8.2, 7.0, 7.5, 6.0, 6.8, 7.1, 6.7],
    "Ease of Learning": [9.0, 8.5, 7.5, 6.0, 7.0, 7.8, 7.2, 7.5, 7.3],
    "Performance": [7.0, 6.5, 8.0, 9.0, 7.4, 6.2, 8.5, 7.0, 7.2],
    "Community Support": [9.5, 8.9, 8.0, 7.5, 8.0, 7.0, 7.8, 7.5, 7.6],
    "Versatility": [9.0, 8.0, 8.2, 7.5, 8.0, 6.5, 7.5, 7.8, 7.4],
    "Libraries & Tools": [9.5, 8.6, 8.3, 7.2, 7.8, 6.9, 7.7, 7.4, 7.3],
}
categorys1 = ["Popularity", "Ease of Learning"]
categorys2 = ["Performance", "Community Support"]
titles = ["Programming Languages Comparison", "Technical Metrics"]
xlabel = "Score"
ylabel = "Programming Languages"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(14, 7), sharey=True)
colors1 = ["#1f77b4", "#ff7f0e"]  # Muted Blue and Orange
colors2 = ["#2ca02c", "#d62728"]  # Muted Green and Red
markers1 = ["o", "s"]  # Circle and Square
markers2 = ["^", "D"]  # Triangle Up and Diamond

# Plotting for ax1 - first two categories
for category, color, marker in zip(categorys1, colors1, markers1):
    ax1.scatter(
        values[category], languages, color=color, label=category, marker=marker, s=100
    )
ax1.set_title(titles[0], fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.legend(fontsize=10)

# Plotting for ax2 - next two categories
for category, color, marker in zip(categorys2, colors2, markers2):
    ax2.scatter(
        values[category], languages, color=color, label=category, marker=marker, s=100
    )
ax2.set_title(titles[1], fontsize=14)
ax2.set_xlabel(xlabel, fontsize=12)
ax2.legend(fontsize=10)

# Common settings
for ax in [ax1, ax2]:
    ax.set_yticks(range(len(languages)))
    ax.set_yticklabels(languages, fontsize=10)
    ax.grid(True, linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("scatter_90.pdf", bbox_inches="tight")
