
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
subjects = [
    "Subject-A",
    "Subject-B",
    "Subject-C",
    "Subject-D",
    "Subject-E",
    "Subject-F",
    "Subject-G",
    "Subject-H",
    "Subject-I",
]

values = {
    "Emotional Intelligence (EQ)": np.random.uniform(0.5, 1.5, 9).tolist(),
    "Cognitive Flexibility": np.random.uniform(0.2, 1.2, 9).tolist(),
    "Stress Resilience": np.random.uniform(0.3, 1.3, 9).tolist(),
    "Memory Retention": np.random.uniform(0.4, 1.4, 9).tolist(),
    "Decision-Making Skills": np.random.uniform(0.1, 1.1, 9).tolist(),
    "Social Interaction": np.random.uniform(0.6, 1.6, 9).tolist(),
}

xlabel = "Subjects"
ylabel = "Score"
title = "Psychological Metrics Analysis"
suptitle = "Scatter Plot of Various Psychological Metrics Across Subjects"
legendlabels = list(values.keys())

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots 2x2
fig, axs = plt.subplots(2, 3, figsize=(12, 8), sharey=True)
colors = ["#0072B2", "#D55E00", "#CC79A7", "#F0E442", "#009E73", "#56B4E9"]
markers = ["o", "s", "D", "^", "v", "P"]
axes = axs.flatten()

# Plot each category
for ax, (category, color, marker) in zip(axes, zip(values.keys(), colors, markers)):
    ax.scatter(
        subjects,
        values[category],
        color=color,
        label=category,
        s=100,
        edgecolor="black",
        alpha=0.7,
        marker=marker,
    )
    ax.set_title(category, fontsize=12)
    ax.set_xticks(range(len(subjects)))
    ax.set_xticklabels(subjects, rotation=45, ha="right")
    ax.set_xlabel(xlabel, fontsize=10)
    ax.set_ylabel(ylabel, fontsize=10)
    ax.legend(loc="upper right")

# Enhance style
for ax in axes:
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.grid(True, linestyle="--", alpha=0.5)
    ax.set_ylim(0, 2)  # Ensure all plots have the same y-axis limits

# Add suptitle
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("scatter_92.pdf", bbox_inches="tight")
