# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
models = [
    "Cubism",
    "Impressionism",
    "Surrealism",
    "Abstract",
    "Modernism",
    "Renaissance",
    "Baroque",
    "Romanticism",
    "Realism",
]
values = {
    "Color Theory": [1.5, 1.7, 1.9, 1.3, 1.8, 1.4, 1.6, 1.2, 1.1],
    "Composition": [0.9, 1.1, 1.3, 0.7, 1.0, 1.4, 1.5, 0.8, 0.6],
    "Creativity": [0.8, 1.0, 1.2, 0.5, 0.9, 1.3, 1.1, 0.7, 0.4],
    "Technical Skill": [1.2, 1.4, 1.6, 0.9, 1.5, 1.8, 1.7, 1.0, 0.8],
    "Conceptual Thinking": [0.6, 0.8, 1.0, 0.4, 0.7, 1.2, 1.3, 0.5, 0.3],
    "Innovation": [1.3, 1.5, 1.7, 1.1, 1.4, 0.9, 1.0, 0.7, 0.5],
}
xlabel = "Art Movements"
ylabel = "Artistic Score"
title = "Art Movement Characteristics"
subtitle = "Comparison of Different Art Movements Across Various Attributes"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots 2x2
fig, axs = plt.subplots(2, 2, figsize=(10, 10), sharey=True)
axes = axs.flatten()

# Colors from a pastel palette
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]

# Plot each category
for ax, (category, color) in zip(axes, zip(values.keys(), colors)):
    ax.scatter(
        models,
        values[category],
        color=color,
        label=category,
        s=100,
        edgecolor="black",
        alpha=0.7,
        marker="o",
    )
    ax.set_title(category, fontsize=12)
    ax.set_xticks(models)
    ax.set_xticklabels(models, rotation=45, ha="right", fontsize=10)
    ax.set_xlabel(xlabel, fontsize=10)
    ax.set_ylabel(ylabel, fontsize=10)
    ax.legend()

# Enhance style
for ax in axes:
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.grid(True, linestyle="--", alpha=0.5)
    ax.set_ylim(0, 2)  # Ensure all plots have the same y-axis limits

# Adding titles and subtitle
plt.suptitle(title, fontsize=14, weight="bold")
plt.figtext(0.5, 0.01, subtitle, ha="center", fontsize=12, style="italic")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("scatter_93.pdf", bbox_inches="tight")
