
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
models = [
    "Netflix",
    "Amazon Prime",
    "Disney+",
    "Hulu",
    "Apple TV+",
    "HBO Max",
    "Peacock",
    "Paramount+",
    "YouTube Premium",
]
values = {
    "Content Variety": [4.8, 4.5, 4.2, 3.8, 3.5, 4.0, 2.8, 3.6, 3.9],
    "User Interface": [4.2, 3.8, 3.9, 4.1, 4.5, 3.7, 3.6, 3.4, 4.0],
    "Subscription Cost": [2.5, 3.0, 4.0, 3.5, 4.5, 3.8, 3.0, 2.7, 4.1],
    "Stream Quality": [4.5, 4.2, 4.7, 4.1, 4.8, 4.0, 3.9, 4.4, 4.3],
    "Original Content": [4.7, 4.0, 4.6, 4.2, 3.5, 4.8, 3.2, 3.8, 4.1],
    "Offline Viewing": [4.0, 3.5, 4.3, 3.8, 4.6, 3.9, 2.5, 3.6, 4.4],
}
xlabel = "Streaming Services"
ylabel = "Score"
xlabels_rotation = 45

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots 2x3
fig, axs = plt.subplots(2, 3, figsize=(14, 10), sharey=True)
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
axes = axs.flatten()

# Plot each category
for ax, (category, color) in zip(axes, zip(values.keys(), colors)):
    ax.scatter(
        models,
        values[category],
        color=color,
        label=category,
        s=100,
        edgecolor="black",
        alpha=0.75,
        marker="o",
    )
    ax.set_title(category)
    ax.set_xticks(np.arange(len(models)))
    ax.set_xticklabels(models, rotation=xlabels_rotation, ha="right")
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.legend()

# Enhance style
for ax in axes:
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.grid(True, linestyle="--", alpha=0.5)
    ax.set_ylim(0, 5)  # Ensure all plots have the same y-axis limits

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_94.pdf", bbox_inches="tight")
