
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate data for processor speed (GHz) vs power consumption (Watts)
x = np.linspace(2, 5, 9)  # GHz
y1 = x * np.random.uniform(15, 20, 9) + np.random.normal(0, 5, 9)
y2 = x * np.random.uniform(10, 15, 9) + np.random.normal(0, 5, 9)
y3 = x * np.random.uniform(5, 10, 9) + np.random.normal(0, 5, 9)

sizes = np.linspace(50, 150, 9)  # Define marker sizes

# Chart text labels
titles = [
    "Low Power Consumption",
    "Medium Power Consumption",
    "High Power Consumption",
]
xlabel = "Processor Speed (GHz)"
ylabel = "Power Consumption (Watts)"
cbar_label = "Processor Speed (GHz)"
suptitle = "Processor Speed vs Power Consumption"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes objects
fig, axs = plt.subplots(1, 3, figsize=(18, 6))

# Define color schemes relevant to tech
colors = ["steelblue", "seagreen", "rebeccapurple"]
markers = ["o", "s", "d"]

# Plot scatter plots
for ax, y, color, marker, title in zip(axs, [y1, y2, y3], colors, markers, titles):
    sc = ax.scatter(
        x,
        y,
        s=sizes,
        c=x,
        cmap="cool",
        alpha=0.6,
        edgecolor="black",
        marker=marker,
    )
    ax.plot(
        x, y, color=color, linestyle="-", alpha=0.7, linewidth=2
    )  # Connect points with solid lines
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.set_ylim(min(y) - 10, max(y) + 10)

# Add color bars to each subplot for color mapping explanation
for ax in axs:
    cb = plt.colorbar(sc, ax=ax, orientation="vertical")
    cb.set_label(cbar_label)

# Set a super title for the entire figure
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlapping
plt.tight_layout(rect=[0, 0.03, 1, 0.95])

# Display the plot
plt.savefig("scatter_96.pdf", bbox_inches="tight")
