
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np # New import as required

# ===================
# Part 2: Data Preparation
# ===================
# Data for historical periods/events
sizes = [25, 18, 15, 12, 10, 8, 7, 5]
labels = [
    "Ancient Egypt\n25%",
    "Classical Greece\n18%",
    "Roman Empire\n15%",
    "Middle Ages\n12%",
    "Renaissance\n10%",
    "Industrial Revolution\n8%",
    "World War I\n7%",
    "Space Age\n5%"
]

# Text and labels
title = "Significant Historical Periods by Impact"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Colors reflecting an antiquity theme
colors = [
    "#d4b483", # Parchment
    "#8a7c54", # Olive
    "#c9b6a3", # Tan
    "#735b32", # Brown
    "#d7c29e", # Light Wheat
    "#907a5e", # Taupe
    "#c8ad8e", # Pale Copper
    "#5f4b32", # Dark Chestnut
]

# Create a treemap
squarify.plot(
    sizes=sizes, label=labels, color=colors, alpha=0.8, text_kwargs={"fontsize": 20, "fontname": "serif"}
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=24, fontname="serif")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_23.pdf", bbox_inches="tight")
