# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [0.25, 0.15, 0.20, 0.10, 0.18, 0.12]
labels = [
    "Corporate\n25%",
    "Criminal\n15%",
    "Environmental\n20%",
    "Family\n10%",
    "Intellectual Property\n18%",
    "Others\n12%",
]

title = "Distribution of Different Types of Law Practices"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Colors representing a professional law domain
colors = ["#00429d", "#4771b2", "#73a2c6", "#a5d5d8", "#d8e7e7", "#eae5e8"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "white"},
    pad=0.25,
)

# Add a title
plt.title(title, fontsize=20)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_24.pdf", bbox_inches="tight")
