
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [0.25, 0.15, 0.20, 0.10, 0.18, 0.12]
labels = [
    "18-24\n25%",
    "25-34\n15%",
    "35-44\n20%",
    "45-54\n10%",
    "55-64\n18%",
    "65+\n12%",
]
title = "Internet Usage Distribution Across Age Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Define a new color scheme
colors = ["#3498db", "#e74c3c", "#2ecc71", "#f1c40f", "#9b59b6", "#34495e"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "black"},
    pad=0.5,
)

# Add title
plt.title(title, fontsize=20, fontweight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_25.pdf", bbox_inches="tight")
