# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [40.5, 25.8, 20.3, 8.4, 3.2, 1.8]
labels = [
    "WhatsApp\n40.5%",
    "WeChat\n25.8%",
    "Facebook Messenger\n20.3%",
    "Telegram\n8.4%",
    "Snapchat\n3.2%",
    "Viber\n1.8%",
]

# Labels and Titles
title = "Market Share of Communication Platforms"
subtitle = "By Percentage of Users in 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))
colors = ["#FF9999", "#66B2FF", "#99FF99", "#FFCC99", "#FFD700", "#FF69B4"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 16},
    ec="white",
)

# Add a title and subtitle
plt.title(title, fontsize=24)
plt.suptitle(subtitle, fontsize=16, y=0.93)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_27.pdf", bbox_inches="tight")
