# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [25.0, 20.0, 15.0, 10.0, 10.0, 10.0, 10.0]
labels = [
    "Fiction\n25.0%",
    "Non-Fiction\n20.0%",
    "Science Fiction\n15.0%",
    "Mystery\n10.0%",
    "Fantasy\n10.0%",
    "Romance\n10.0%",
    "Horror\n10.0%",
]
# Titles and Text Labels
title = "Distribution of Book Genres in the Market"
suptitle = "Literature Genre Analysis"
savefile = "tree_3_7.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Colors: Warm and inviting palette for literature theme
colors = ["#FA8072", "#87CEEB", "#FFA07A", "#20B2AA", "#9370DB", "#FFD700", "#FF69B4"]


# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="black",
)

# Remove axes
plt.axis("off")

# Add Titles
plt.title(title, fontsize=20, fontweight="bold")
plt.suptitle(suptitle, fontsize=24, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_28.pdf", bbox_inches="tight")
