
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [23.0, 19.0, 17.0, 10.0, 18.0, 13.0]
labels = [
    "Solar\n23.0%",
    "Wind\n19.0%",
    "Hydroelectric\n17.0%",
    "Nuclear\n10.0%",
    "Coal\n18.0%",
    "Natural Gas\n13.0%",
]

title = "Global Energy Production Sources\n(2023)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 9))
colors = ["#FFD700", "#87CEEB", "#4682B4", "#808080", "#A52A2A", "#FF6347"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="white",
)

# Set title
plt.title(title, fontsize=24, weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_29.pdf", bbox_inches="tight")
