
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [35.0, 25.0, 15.0, 10.0, 5.0, 4.0, 3.0, 3.0]
labels = [
    "WhatsApp\n35.0%",
    "WeChat\n25.0%",
    "Facebook Messenger\n15.0%",
    "Telegram\n10.0%",
    "Signal\n5.0%",
    "Discord\n4.0%",
    "Viber\n3.0%",
    "Line\n3.0%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors =[
    "#66c2a5",
    "#fc8d62",
    "#8da0cb",
    "#e78ac3",
    "#a6d854",
    "#ffd92f",
    "#e5c494",
    "#b3b3b3",
]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes, label=labels, color=colors, alpha=0.8, text_kwargs={"fontsize": 18, "fontweight": "bold"}
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_36.pdf", bbox_inches="tight")
