# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [30.00, 25.00, 20.00, 10.00, 8.00, 5.00, 2.00]
labels = [
    "Solar\n30.00%",
    "Wind\n25.00%",
    "Hydro\n20.00%",
    "Nuclear\n10.00%",
    "Coal\n8.00%",
    "Natural Gas\n5.00%",
    "Oil\n2.00%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Colors for energy sources
colors = [
    "#FFCC00",  # Solar - Yellow
    "#66CCFF",  # Wind - Light Blue
    "#33CC33",  # Hydro - Green
    "#9999FF",  # Nuclear - Light Purple
    "#666666",  # Coal - Grey
    "#FF6666",  # Natural Gas - Light Red
    "#FF9900",  # Oil - Orange
]

# Create a treemap
squarify.plot(
    sizes=sizes, label=labels, color=colors, alpha=0.8, text_kwargs={"fontsize": 18}
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_40.pdf", bbox_inches="tight")
