# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [35.00, 20.00, 15.00, 10.00, 8.00, 6.00, 4.00, 2.00]
labels = [
    "Car\n35.00%",
    "Bus\n20.00%",
    "Train\n15.00%",
    "Bicycle\n10.00%",
    "Airplane\n8.00%",
    "Boat\n6.00%",
    "Motorbike\n4.00%",
    "Walk\n2.00%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

colors = [
    "#1f77b4",  # Car
    "#ff7f0e",  # Bus
    "#2ca02c",  # Train
    "#d62728",  # Bicycle
    "#9467bd",  # Airplane
    "#8c564b",  # Boat
    "#e377c2",  # Motorbike
    "#7f7f7f",  # Walk
]

# Create a treemap
squarify.plot(
    sizes=sizes, label=labels, color=colors, alpha=0.8, text_kwargs={"fontsize": 18}
)


# Remove axes
plt.axis("off")

# Set the title
plt.title("Market Share of Different Modes of Transportation", fontsize=24)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_41.pdf", bbox_inches="tight")
