# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# New data for global smartphone market share
sizes = [0.30, 0.25, 0.20, 0.10, 0.10, 0.05]
labels = [
    "Samsung\n30%",
    "Apple\n25%",
    "Xiaomi\n20%",
    "Oppo\n10%",
    "Vivo\n10%",
    "Others\n5%",
]
title = "Global Smartphone Market Share"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Color scheme suitable for technology domain
colors = ["#1f78b4", "#33a02c", "#e31a1c", "#ff7f00", "#6a3d9a", "#b15928"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 20, "color": "white"},
    pad=0.3,
)

# Add a title
plt.title(title, fontsize=24, color="#333333")

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot
plt.savefig("tree_42.pdf", bbox_inches="tight")
