# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# New data for philosophical schools' popularity
sizes = [0.28, 0.22, 0.18, 0.15, 0.10, 0.07]
labels = [
    "Existentialism\n28%",
    "Analytic Philosophy\n22%",
    "Phenomenology\n18%",
    "Postmodernism\n15%",
    "Pragmatism\n10%",
    "Others\n7%",
]
title = "Popularity of Philosophical Schools"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Color palette reflecting a contemplative theme
colors = ["#3c5488", "#4a87d4", "#76b7c3", "#aab7a9", "#efd399", "#f28e2b"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 20, "color": "white"},
    pad=0.3,
)

# Add a title
plt.title(title, fontsize=24)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot
plt.savefig("tree_43.pdf", bbox_inches="tight")
