
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# New data for healthcare expenditures (in percentages)
sizes = [0.30, 0.20, 0.18, 0.15, 0.10, 0.07]
labels = [
    "Inpatient Services\n30%",
    "Outpatient Services\n20%",
    "Prescription Drugs\n18%",
    "Medical Supplies\n15%",
    "Preventive Care\n10%",
    "Other\n7%",
]
title = "Healthcare Expenditure Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3", "#a6d854", "#ffd92f"]
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 20, "color": "white"},
    pad=0.3,
)

# Add a title
plt.title(title, fontsize=24)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot
plt.savefig("tree_44.pdf", bbox_inches="tight")
