# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data: Expenditure percentages for different health services
sizes = [0.35, 0.20, 0.18, 0.12, 0.10, 0.05]
labels = [
    "Hospital Care\n35%",
    "Physician Services\n20%",
    "Prescription Drugs\n18%",
    "Dental Services\n12%",
    "Nursing Care\n10%",
    "Other Services\n5%",
]

title = "Health Expenditure Distribution"
supertitle = "Distribution of Expenses in Healthcare Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Style parameters
colors = ["#4f83cc", "#76a5af", "#9fc5e8", "#cfe2f3", "#3c78d8", "#6d9eeb"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "black"},
    pad=0.3,
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=20, fontweight="bold")
plt.suptitle(supertitle, fontsize=24, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save plot
plt.savefig("tree_47.pdf", bbox_inches="tight")
