
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [0.40, 0.25, 0.15, 0.10, 0.07, 0.03]
labels = [
    "Soccer\n40%",
    "Basketball\n25%",
    "Tennis\n15%",
    "Cricket\n10%",
    "Baseball\n7%",
    "Rugby\n3%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#FF6347", "#4682B4", "#32CD32", "#FFD700", "#6A5ACD", "#FF1493"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "white"},
    pad=0.25,
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_48.pdf", bbox_inches="tight")
