# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [0.30, 0.25, 0.20, 0.15, 0.07, 0.03]
labels = [
    "Toyota\n30%",
    "Volkswagen\n25%",
    "Ford\n20%",
    "Honda\n15%",
    "BMW\n7%",
    "Others\n3%",
]

# Text label parameters
title = "Market Share of Car Brands (2023)"
legend_labels = ["Toyota", "Volkswagen", "Ford", "Honda", "BMW", "Others"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#FF9999", "#66B2FF", "#99FF99", "#FFCC99", "#FFD700", "#FFB6C1"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "white"},
    pad=0.25,
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=24, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_49.pdf", bbox_inches="tight")
