
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [0.30, 0.25, 0.20, 0.10, 0.08, 0.07]
labels = [
    "Empiricism\n30%",
    "Rationalism\n25%",
    "Existentialism\n20%",
    "Absurdism\n10%",
    "Structuralism\n8%",
    "Other\n7%",
]
title = "Distribution of Philosophical Schools of Thought"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#6b705c", "#cb997e", "#ddbea9", "#ffe8d6", "#b7b7a4", "#a5a58d"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 16, "color": "white"},
    pad=0.25,
)

# Remove axes
plt.axis("off")

# Title
plt.title(title, fontsize=24, weight='bold', color="#3d405b")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_50.pdf", bbox_inches="tight")
