
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [0.25, 0.20, 0.18, 0.15, 0.12, 0.10]
labels = [
    "AI Assistants\n25%",
    "Drones\n20%",
    "Smart Home Devices\n18%",
    "Wearable Tech\n15%",
    "AR/VR\n12%",
    "Other\n10%",
]

# Text properties
title = "Market Share of Emerging Tech Trends in 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#74c476", "#31a354", "#006d2c", "#fd8d3c", "#e6550d", "#a63603"]

# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "white"},
    pad=0.25,
)

# Title setting
plt.title(title, fontsize=24)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_52.pdf", bbox_inches="tight")
