# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [0.35, 0.25, 0.20, 0.10, 0.05, 0.05]
labels = [
    "Solar Power\n35%",
    "Wind Energy\n25%",
    "Hydropower\n20%",
    "Geothermal\n10%",
    "Biomass\n5%",
    "Other\n5%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

colors = ["#A6CEE3", "#1F78B4", "#B2DF8A", "#33A02C", "#FB9A99", "#E31A1C"]
text_kwargs = {"fontsize": 18, "color": "white"}

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    text_kwargs=text_kwargs,
    pad=0.25,
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig("tree_53.pdf", bbox_inches="tight")
