

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [27.5, 23.2, 15.8, 12.5, 10.6, 6.4, 4.0]
labels = [
    "Netflix\n27.5%",
    "YouTube\n23.2%",
    "Amazon Prime\n15.8%",
    "Disney+\n12.5%",
    "Hulu\n10.6%",
    "HBO Max\n6.4%",
    "Others\n4.0%",
]

title = 'Streaming Service Market Shares'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#FFA07A", "#20B2AA", "#FFB347", "#FF9671"]
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="white",
)

# Add title
plt.title(title, fontsize=22, weight="bold")

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_55.pdf", bbox_inches="tight")

