
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [40.8, 24.3, 18.5, 7.3, 5.1, 4.0]
labels = [
    "Netflix\n40.8%",
    "Amazon Prime\n24.3%",
    "Disney+\n18.5%",
    "Hulu\n7.3%",
    "Apple TV+\n5.1%",
    "Others\n4.0%",
]
title = 'Market Share of Streaming Platforms'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#FF6384", "#36A2EB", "#FFCE56", "#4BC0C0", "#9966FF", "#FF9F40"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.75,
    text_kwargs={"fontsize": 16, "weight": "bold", "color": "white"},
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=24, weight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_57.pdf", bbox_inches="tight")
