
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [30.23, 28.19, 20.45, 10.12, 6.48, 4.53]
labels = [
    "Apple\n30.23%",
    "Samsung\n28.19%",
    "Huawei\n20.45%",
    "Xiaomi\n10.12%",
    "Oppo\n6.48%",
    "Others\n4.53%",
]
title = 'Market Share of Leading Technology Brands'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1", "#955251"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=22, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_59.pdf", bbox_inches="tight")
