
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [30, 25, 20, 10, 10, 5]
labels = [
    "Depression\n30%",
    "Anxiety\n25%",
    "Bipolar Disorder\n20%",
    "OCD\n10%",
    "PTSD\n10%",
    "Schizophrenia\n5%",
]
title = 'Prevalence of Common Mental Health Disorders'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
colors = ["#a2cffe", "#b39eb5", "#ffdfba", "#d7f1d0", "#f7cac9", "#c6c08e"]
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": 'bold'},
    ec="black",
)

# Add a title
plt.title(title, fontsize=22, weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_60.pdf", bbox_inches="tight")
