
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [35, 25, 20, 10, 5, 5]
labels = [
    "Solar\n35%",
    "Wind\n25%",
    "Hydro\n20%",
    "Nuclear\n10%",
    "Coal\n5%",
    "Natural Gas\n5%",
]
title = 'Market Share of Different Energy Sources'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
colors = ["#FFD700", "#87CEEB", "#00BFFF", "#A9A9A9", "#708090", "#FF8C00"]
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs={"fontsize": 18, "weight": 'bold'},
    ec="black",
)

# Add a title
plt.title(title, fontsize=22, weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_61.pdf", bbox_inches="tight")
