# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [40, 25, 15, 10, 7, 3]
labels = [
    "Physics",
    "Chemistry",
    "Biology",
    "Astronomy",
    "Earth Sciences",
    "Mathematics",
]
title = "Scientific Research Focus Areas Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1b9e77", "#d95f02", "#7570b3", "#e7298a", "#66a61e", "#e6ab02"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 6))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 13, "color": "white", "fontweight": "bold"},
    ec="black",  # edge color
)

# Add title
plt.title(title, fontsize=20, color="#333333")

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_68.pdf", bbox_inches="tight")
