# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================

# Data
sizes = [35, 25, 18, 12, 10]
labels = [
    "IT\n35%",
    "Healthcare\n25%",
    "Education\n18%",
    "Manufacturing\n12%",
    "Retail\n10%",
]
title = "Employment Distribution by Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#5DADE2", "#48C9B0", "#F4D03F", "#EC7063", "#AF7AC5"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "black"},
    pad=True,
    ec="black",
)

# Set title
plt.title(title, fontsize=20)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_73.pdf", bbox_inches="tight")
